/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ChickenBreedingCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation UID = new ResourceLocation("chickens", "chicken_breeding");
    public static final Component TITLE = new TranslatableComponent("gui.breeding");
    IGuiHelper guiHelper;

    public ChickenBreedingCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("chickens", "textures/gui/breeding.png"), 0, 0, 82, 54).addPadding(0, 20, 0, 0).build();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.guiHelper.createDrawable(new ResourceLocation("chickens", "textures/gui/breeding_icon.png"), 0, 0, 16, 16);
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @NotNull
    public Class getRecipeClass() {
        return Recipe.class;
    }

    public void draw(@NotNull Recipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull PoseStack stack, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
        IDrawableStatic arrowDrawable = this.guiHelper.createDrawable(new ResourceLocation("chickens", "textures/gui/breeding.png"), 82, 0, 7, 7);
        this.guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        Minecraft.m_91087_().f_91062_.m_92883_(stack, recipe.chance + "%", 5.0f, 60.0f, 0);
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        list.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.parent1}));
        list.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.parent2}));
        ingredients.setInputIngredients(list);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.child);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 10, 15);
        guiItemStacks.init(1, true, 53, 15);
        guiItemStacks.init(2, false, 33, 30);
        guiItemStacks.set(ingredients);
    }

    public static class Recipe {
        private final ItemStack parent1;
        private final ItemStack parent2;
        private final ItemStack child;
        private final float chance;

        public Recipe(ItemStack parent1, ItemStack parent2, ItemStack child, float chance) {
            this.parent1 = parent1;
            this.parent2 = parent2;
            this.child = child;
            this.chance = chance;
        }
    }
}

